Rem
Rem $Header: mqssl_adm_setup.sql 19-jan-2007.13:33:50 chall    Exp $
Rem
Rem mqssl_adm_setup.sql
Rem
Rem Copyright (c) 2007, Oracle.  All rights reserved.  
Rem
Rem    NAME
Rem      mqssl_adm_setup.sql - SQL script to configure MGW entities.
Rem
Rem    DESCRIPTION
Rem      This script sets up a "round-trip" propagation to illustrate both
Rem      outbound (AQ->MQ) and inbound (MQ->AQ) propagation using SSL for
Rem      the WebSphere MQ connections. An outbound propagation job moves 
Rem      messages from the AQ queue MGWUSER.MGW_BASIC_SRC to a user supplied
Rem      WebSphere MQ queue. An inbound propagation job messages from the 
Rem      same user supplied WebSphere MQ queue to the AQ queue 
Rem      MGWUSER.MGW_BASIC_DEST. The end result should be messages 
Rem      moved from MGWUSER.MGW_BASIC_SRC to MGWUSER.MGW_BASIC_DEST.
Rem
Rem PREREQUISITES:
Rem
Rem * The following database entities are assumed:
Rem   - Users: mgwagent, mgwadm, mgwuser
Rem   - AQ Queues: mgwuser.mgw_basic_src, mgwuser.mgw_basic_dest
Rem
Rem * The WebSphere MQ channel to be used has been configured for SSL.
Rem
Rem * A JSSE truststore file and optionally a keystore file are accessible
Rem   by the node on which the Messaging Gateway agent will run, i.e., 
Rem   the node running the Oracle database.
Rem
Rem --------------------------------------------------------------------------
Rem
Rem This script does the following (via the dbms_mgwadm package):
Rem
Rem * Sets the agent user connection information:
Rem   username: mgwagent
Rem   password: mgwagent
Rem   database: <user supplied>
Rem
Rem * Creates an WebSphere MQ link
Rem   Link name: mqssl_link
Rem
Rem * Creates an WebSphere MQ foreign queue.
Rem   Name:   destq
Rem   Link:   mqssl_link
Rem   Native: <user supplied>
Rem
Rem * Creates an OUTBOUND propagation job.
Rem   Job:    job_mqssl_out
Rem   Source: mgwuser.mgw_basic_src
Rem   Dest:   destq@mqssl_link
Rem
Rem * Creates an INBOUND propagation job.
Rem   Job:    job_mqssl_in
Rem   Source: destq@mqssl_link
Rem   Dest:   mgwuser.mgw_basic_dest
Rem
Rem ==========================================================================

connect mgwadm/mgwadm;
set serveroutput on

variable gv_database            VARCHAR2(32);
variable gv_mq_queue_manager    VARCHAR2(32);
variable gv_mq_queue_name       VARCHAR2(32);
variable gv_mq_channel          VARCHAR2(32);
variable gv_mq_inbound_log_queue  VARCHAR2(32);
variable gv_mq_outbound_log_queue VARCHAR2(32);
variable gv_mq_username         VARCHAR2(32);
variable gv_mq_password         VARCHAR2(32);
variable gv_mq_host             VARCHAR2(48);
variable gv_mq_port             VARCHAR2(6);
variable gv_mq_ssl_ciphersuite  VARCHAR2(100);

variable gv_jsse_truststore            VARCHAR2(200);
variable gv_jsse_truststore_password   VARCHAR2(100);
variable gv_jsse_keystore              VARCHAR2(200);
variable gv_jsse_keystore_password     VARCHAR2(100);

--
-- WARNING!!!! The values below must be set before this script is run.
--
begin
  :gv_database         := '';     -- database specifier for agent user
  :gv_mq_queue_manager := ;
  :gv_mq_queue_name    := ;
  :gv_mq_channel       := ;       -- channel must be configured for SSL
  :gv_mq_host          := ;
  :gv_mq_port          := ;
  :gv_mq_username      := 'mqm';  -- must be non-NULL for WebSphere MQ 6.0
  :gv_mq_password      := 'mqm';
  :gv_mq_inbound_log_queue  := ;
  :gv_mq_outbound_log_queue := ;

  -- SSL CipherSuite used by the channel; e.g., 'SSL_RSA_WITH_RC4_128_MD5'
  :gv_mq_ssl_ciphersuite := ;

  -- values for agent's Java JSSE truststore and keystore properties
  -- truststore is always needed
  -- keystore is needed only if using SSL client authentication
  :gv_jsse_truststore          := NULL;
  :gv_jsse_truststore_password := NULL;
  :gv_jsse_keystore            := NULL;
  :gv_jsse_keystore_password   := NULL;
end;
/

prompt
prompt Setting the gateway agent user for the default agent
prompt 

rem   If we do not set the database argument it will default to the
rem   ORACLE_SID of the MGW process (the listener process).
begin
  dbms_mgwadm.alter_agent(
      agent_name => 'default_agent',
      username   => 'mgwagent',
      password   => 'mgwagent',
      database   => RTRIM(:gv_database));
end;
/

prompt
prompt Setting agent Java JSSE properties for the truststore and keystore
prompt

declare
  v_agent varchar2(30) := 'default_agent';
begin

  -- Set Java properties for the agent that specify the JSSE truststore 
  -- and keystore to be used by the MGW agent. The truststore should 
  -- always be needed since it contains the public certificate of the 
  -- queue manager being usd. The keystore should only be needed if 
  -- the channel is configured for SSL client authentication.
  --
  -- The MGW_AGENT_OPTIONS view can be used to see which options have
  -- been configured for an agent using dbms_mgwadm.set_option.
  --

  -- specify the truststore related properties
  if (:gv_jsse_truststore IS NOT NULL) then
    dbms_mgwadm.set_option(target_type  => dbms_mgwadm.AGENT_JAVA_PROP,
                           target_name  => v_agent,
                           option_name  => 'javax.net.ssl.trustStore',
                           option_value => RTRIM(:gv_jsse_truststore),
                           encrypted    => false);
  end if;

  if (:gv_jsse_truststore_password IS NOT NULL) then
    dbms_mgwadm.set_option(target_type => dbms_mgwadm.AGENT_JAVA_PROP,
                           target_name  => v_agent,
                           option_name  => 'javax.net.ssl.trustStorePassword',
                           option_value => RTRIM(:gv_jsse_truststore_password),
                           encrypted    => true);
  end if;

  -- specify the keystore related properties
  if (:gv_jsse_keystore IS NOT NULL) then
    dbms_mgwadm.set_option(target_type  => dbms_mgwadm.AGENT_JAVA_PROP,
                           target_name  => v_agent,
                           option_name  => 'javax.net.ssl.keyStore',
                           option_value => RTRIM(:gv_jsse_keystore),
                           encrypted    => false);
  end if;

  if (:gv_jsse_keystore_password IS NOT NULL) then
    dbms_mgwadm.set_option(target_type  => dbms_mgwadm.AGENT_JAVA_PROP,
                           target_name  => v_agent,
                           option_name  => 'javax.net.ssl.keyStorePassword',
                           option_value => RTRIM(:gv_jsse_keystore_password),
                           encrypted    => true);
  end if;

end;
/

prompt
prompt Creating MQSeries link
prompt

declare
  v_options sys.mgw_properties := NULL;
  v_prop    sys.mgw_mqseries_properties;
begin
  if (:gv_mq_queue_manager IS NULL) then
    dbms_output.put_line('queue manager must be specified');
  end if;

  if (:gv_mq_ssl_ciphersuite IS NULL) then
    dbms_output.put_line('SSL CipherSuite must be specified');
  end if;

  -- set options if desired
  -- MQ_SSLCIPHERSUITE: the SSL CipherSuite configured for the channel
  --
  v_options := sys.mgw_properties( 
     sys.mgw_property('MQ_SSLCIPHERSUITE', RTRIM(:gv_mq_ssl_ciphersuite))
     );

  -- set certain mqseries properties used for MQSeries
  -- NOTE: This information must be changed for your MQSeries setup.
  v_prop := sys.mgw_mqseries_properties.construct();

  v_prop.max_connections := 1;

  -- queue manager name (required)
  v_prop.queue_manager := RTRIM(:gv_mq_queue_manager);

   -- hostname for queue manager host (required)
  v_prop.hostname := RTRIM(:gv_mq_host);

  -- channel name (required)
  v_prop.channel  := RTRIM(:gv_mq_channel);

  -- port (required -- 1414 is MQSeries default)
  v_prop.port := RTRIM(:gv_mq_port);

  -- username given to queue manager
  if (:gv_mq_username IS NOT NULL) then
    v_prop.username := RTRIM(:gv_mq_username);
  end if;

  -- password given to queue manager
  if (:gv_mq_password IS NOT NULL) then
    v_prop.password := RTRIM(:gv_mq_password);
  end if;

  -- name of MQSeries queue to be used for MGW logging on inbound jobs
  if (:gv_mq_inbound_log_queue IS NOT NULL) then
    v_prop.inbound_log_queue := RTRIM(:gv_mq_inbound_log_queue);
  end if;

  -- name of MQSeries queue to be used for MGW logging on outbound jobs
  if (:gv_mq_outbound_log_queue IS NOT NULL) then
    v_prop.outbound_log_queue := RTRIM(:gv_mq_outbound_log_queue);
  end if;

  -- create link
  dbms_mgwadm.create_msgsystem_link(
      linkname   => 'mqssl_link',      -- link name
      agent_name => 'default_agent',   -- MGW agent responsible for this link
      properties => v_prop,            -- WebSphere MQ driver properties
      options    => v_options);        -- optional link options
end;
/

prompt
prompt Registering foreign queue
prompt

declare
  v_options sys.mgw_properties;
begin
  -- Set options for register foreign queue
  --  MQ_openOptions: 2066 is TODO
  v_options := sys.mgw_properties(
        sys.mgw_property('MQ_openOptions', '2066') );

  dbms_mgwadm.register_foreign_queue(
      name     => 'destq',                   -- MGW foreign queue name
      linkname => 'mqssl_link',              -- name of link to use
      provider_queue => RTRIM(:gv_mq_queue_name), -- name of MQSeries queue
      domain   => dbms_mgwadm.DOMAIN_QUEUE,  -- single consumer queue
      options  => v_options );
end;
/

prompt
prompt Adding outbound propagation job
prompt

begin
  -- source must be an AQ queue (schema.name)
  -- destination must be a registered non-Oracle queue (queue@link)
  -- subscriber rule applies to AQ subscriber
  -- exception queue, if any, must be a NORMAL AQ queue with same payload
  --   type as the source queue (schema.name)
  --
  -- for this sample:
  -- no selection rule used for this job
  -- no transformation invoked on AQ dequeue
  -- no exception queue
  dbms_mgwadm.create_job(
      job_name    => 'job_mqssl_out',
      propagation_type => dbms_mgwadm.outbound_propagation,
      source      => 'mgwuser.mgw_basic_src',  -- AQ queue
      destination => 'destq@mqssl_link');      -- registered non-Oracle queue
end;
/

prompt
prompt Adding inbound propagation job
prompt

begin
  -- source must be a registered non-Oracle queue (queue@link)
  -- destination must be an AQ queue (schema.name)
  -- exception queue, if any, must be a registered non-Oracle queue that
  --   uses the same link as the source queue (queue@link)
  --
  -- for this sample:
  -- no selection rule can be used for this job
  -- no transformation invoked on AQ enqueue
  -- no exception queue
  dbms_mgwadm.create_job(
      job_name    => 'job_mqssl_in',
      propagation_type => dbms_mgwadm.inbound_propagation,
      source      => 'destq@mqssl_link',        -- registered non-Oracle queue
      destination => 'mgwuser.mgw_basic_dest'); -- AQ queue
end;
/
